/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk;

public final class UploadOptions {
    public static final UploadOptions DEFAULT = new Builder().overrideFile(false).partialUpload(false).build();
    public static final UploadOptions OVERRIDE_FILE = new Builder().overrideFile(true).partialUpload(false).build();
    public static final UploadOptions PARTIAL_UPLOAD = new Builder().overrideFile(false).partialUpload(true).build();
    private final boolean overrideFile;
    private final boolean partialUpload;

    public static Builder create() {
        return DEFAULT.newBuilder();
    }

    private UploadOptions(boolean overrideFile, boolean partialUpload) {
        this.overrideFile = overrideFile;
        this.partialUpload = partialUpload;
    }

    public boolean overrideFile() {
        return this.overrideFile;
    }

    public boolean partialUpload() {
        return this.partialUpload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadOptions that = (UploadOptions)o;
        return this.overrideFile != that.overrideFile && this.partialUpload != that.partialUpload;
    }

    public int hashCode() {
        int result = this.overrideFile ? 1 : 0;
        result = 31 * result + (this.partialUpload ? 1 : 0);
        return result;
    }

    public Builder newBuilder() {
        return new Builder(this.overrideFile, this.partialUpload);
    }

    public static class Builder {
        private boolean overrideFile;
        private boolean partialUpload;

        private Builder() {
        }

        private Builder(boolean overrideFile, boolean partialUpload) {
            this.overrideFile = overrideFile;
            this.partialUpload = partialUpload;
        }

        public Builder overrideFile(boolean overrideFile) {
            this.overrideFile = overrideFile;
            return this;
        }

        public Builder partialUpload(boolean partialUpload) {
            this.partialUpload = partialUpload;
            return this;
        }

        public UploadOptions build() {
            return new UploadOptions(this.overrideFile, this.partialUpload);
        }
    }
}

