/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk;

import java.util.Objects;

public final class DownloadOptions {
    public static final DownloadOptions DEFAULT = new Builder().forceDownload(false).skipFilename(false).contentType(null).build();
    private final boolean skipFilename;
    private final boolean forceDownload;
    private final String contentType;

    public static Builder create() {
        return DEFAULT.newBuilder();
    }

    private DownloadOptions(boolean skipFilename, boolean forceDownload, String contentType) {
        this.skipFilename = skipFilename;
        this.forceDownload = forceDownload;
        this.contentType = contentType;
    }

    public String contentType() {
        return this.contentType;
    }

    public boolean skipFilename() {
        return this.skipFilename;
    }

    public boolean forceDownload() {
        return this.forceDownload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadOptions that = (DownloadOptions)o;
        if (this.skipFilename != that.skipFilename) {
            return false;
        }
        if (this.forceDownload != that.forceDownload) {
            return false;
        }
        return Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        int result = this.skipFilename ? 1 : 0;
        result = 31 * result + (this.forceDownload ? 1 : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        return result;
    }

    public Builder newBuilder() {
        return new Builder(this.skipFilename, this.forceDownload, this.contentType);
    }

    public static class Builder {
        private boolean skipFilename;
        private boolean forceDownload;
        private String contentType;

        private Builder() {
        }

        private Builder(boolean skipFilename, boolean forceDownload, String contentType) {
            this.skipFilename = skipFilename;
            this.forceDownload = forceDownload;
            this.contentType = contentType;
        }

        public Builder skipFilename(boolean skipFilename) {
            this.skipFilename = skipFilename;
            return this;
        }

        public Builder forceDownload(boolean forceDownload) {
            this.forceDownload = forceDownload;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public DownloadOptions build() {
            return new DownloadOptions(this.skipFilename, this.forceDownload, this.contentType);
        }
    }
}

