/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk;

import com.pcloud.sdk.Authenticator;
import com.pcloud.sdk.Call;
import com.pcloud.sdk.Checksums;
import com.pcloud.sdk.DataSink;
import com.pcloud.sdk.DataSource;
import com.pcloud.sdk.DownloadOptions;
import com.pcloud.sdk.FileLink;
import com.pcloud.sdk.ProgressListener;
import com.pcloud.sdk.RemoteEntry;
import com.pcloud.sdk.RemoteFile;
import com.pcloud.sdk.RemoteFolder;
import com.pcloud.sdk.UploadOptions;
import com.pcloud.sdk.UserInfo;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okio.BufferedSource;

public interface ApiClient {
    public Call<RemoteFolder> listFolder(long var1);

    public Call<RemoteFolder> listFolder(long var1, boolean var3);

    public Call<RemoteFolder> listFolder(String var1);

    public Call<RemoteFolder> listFolder(String var1, boolean var2);

    public Call<RemoteFolder> createFolder(long var1, String var3);

    public Call<RemoteFolder> createFolder(RemoteFolder var1, String var2);

    public Call<RemoteFolder> createFolder(String var1);

    public Call<Boolean> deleteFolder(long var1);

    public Call<Boolean> deleteFolder(long var1, boolean var3);

    public Call<Boolean> deleteFolder(RemoteFolder var1);

    public Call<Boolean> deleteFolder(RemoteFolder var1, boolean var2);

    public Call<Boolean> deleteFolder(String var1);

    public Call<Boolean> deleteFolder(String var1, boolean var2);

    public Call<RemoteFolder> renameFolder(long var1, String var3);

    public Call<RemoteFolder> renameFolder(RemoteFolder var1, String var2);

    public Call<RemoteFolder> moveFolder(long var1, long var3);

    public Call<RemoteFolder> moveFolder(RemoteFolder var1, RemoteFolder var2);

    public Call<RemoteFolder> moveFolder(String var1, String var2);

    public Call<RemoteFolder> copyFolder(long var1, long var3);

    public Call<RemoteFolder> copyFolder(RemoteFolder var1, RemoteFolder var2);

    public Call<RemoteFolder> copyFolder(long var1, long var3, boolean var5);

    public Call<RemoteFolder> copyFolder(RemoteFolder var1, RemoteFolder var2, boolean var3);

    public Call<RemoteFile> createFile(RemoteFolder var1, String var2, DataSource var3);

    public Call<RemoteFile> createFile(RemoteFolder var1, String var2, DataSource var3, UploadOptions var4);

    public Call<RemoteFile> createFile(RemoteFolder var1, String var2, DataSource var3, Date var4, ProgressListener var5);

    public Call<RemoteFile> createFile(RemoteFolder var1, String var2, DataSource var3, Date var4, ProgressListener var5, UploadOptions var6);

    public Call<RemoteFile> createFile(long var1, String var3, DataSource var4);

    public Call<RemoteFile> createFile(long var1, String var3, DataSource var4, UploadOptions var5);

    public Call<RemoteFile> createFile(long var1, String var3, DataSource var4, Date var5, ProgressListener var6);

    public Call<RemoteFile> createFile(long var1, String var3, DataSource var4, Date var5, ProgressListener var6, UploadOptions var7);

    public Call<RemoteFile> createFile(String var1, String var2, DataSource var3);

    public Call<RemoteFile> createFile(String var1, String var2, DataSource var3, UploadOptions var4);

    public Call<RemoteFile> createFile(String var1, String var2, DataSource var3, Date var4, ProgressListener var5);

    public Call<RemoteFile> createFile(String var1, String var2, DataSource var3, Date var4, ProgressListener var5, UploadOptions var6);

    public Call<Boolean> deleteFile(RemoteFile var1);

    public Call<Boolean> deleteFile(long var1);

    public Call<Boolean> deleteFile(String var1);

    public Call<FileLink> createFileLink(RemoteFile var1, DownloadOptions var2);

    public Call<FileLink> createFileLink(long var1, DownloadOptions var3);

    public Call<FileLink> createFileLink(String var1, DownloadOptions var2);

    public Call<Void> download(FileLink var1, DataSink var2);

    public Call<Void> download(FileLink var1, DataSink var2, ProgressListener var3);

    public Call<Void> download(FileLink var1, URL var2, DataSink var3, ProgressListener var4);

    public Call<BufferedSource> download(RemoteFile var1);

    public Call<BufferedSource> download(FileLink var1);

    public Call<BufferedSource> download(FileLink var1, URL var2);

    public Call<RemoteFile> copyFile(long var1, long var3);

    public Call<RemoteFile> copyFile(long var1, long var3, boolean var5);

    public Call<RemoteFile> copyFile(RemoteFile var1, RemoteFolder var2);

    public Call<RemoteFile> copyFile(RemoteFile var1, RemoteFolder var2, boolean var3);

    public Call<? extends RemoteEntry> copy(RemoteEntry var1, RemoteFolder var2);

    public Call<? extends RemoteEntry> copy(RemoteEntry var1, RemoteFolder var2, boolean var3);

    public Call<? extends RemoteEntry> copy(String var1, long var2);

    public Call<? extends RemoteEntry> copy(String var1, long var2, boolean var4);

    public Call<? extends RemoteEntry> move(RemoteEntry var1, RemoteFolder var2);

    public Call<? extends RemoteEntry> move(String var1, long var2);

    public Call<Boolean> delete(RemoteEntry var1);

    public Call<Boolean> delete(String var1);

    public Call<? extends RemoteEntry> rename(RemoteEntry var1, String var2);

    public Call<? extends RemoteEntry> rename(String var1, String var2);

    public Call<RemoteFile> loadFile(long var1);

    public Call<RemoteFile> loadFile(String var1);

    public Call<RemoteFolder> loadFolder(long var1);

    public Call<RemoteFolder> loadFolder(String var1);

    public Call<RemoteFile> moveFile(long var1, long var3);

    public Call<RemoteFile> moveFile(RemoteFile var1, RemoteFolder var2);

    public Call<RemoteFile> moveFile(String var1, String var2);

    public Call<RemoteFile> renameFile(long var1, String var3);

    public Call<RemoteFile> renameFile(RemoteFile var1, String var2);

    public Call<UserInfo> getUserInfo();

    public Call<Checksums> getChecksums(long var1);

    public Call<Checksums> getChecksums(String var1);

    public Builder newBuilder();

    public Executor callbackExecutor();

    public Dispatcher dispatcher();

    public ConnectionPool connectionPool();

    public Cache cache();

    public int readTimeoutMs();

    public int writeTimeoutMs();

    public int connectTimeoutMs();

    public long progressCallbackThreshold();

    public Authenticator authenticator();

    public String apiHost();

    public void shutdown();

    public static interface Builder {
        public Builder cache(Cache var1);

        public Builder connectionPool(ConnectionPool var1);

        public Builder dispatcher(Dispatcher var1);

        public Builder withClient(OkHttpClient var1);

        public Builder readTimeout(long var1, TimeUnit var3);

        public Builder writeTimeout(long var1, TimeUnit var3);

        public Builder connectTimeout(long var1, TimeUnit var3);

        public Builder authenticator(Authenticator var1);

        public Builder callbackExecutor(Executor var1);

        public Builder progressCallbackThreshold(long var1);

        public Builder apiHost(String var1);

        public ApiClient create();
    }
}

