/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.IAccessTokenCache;
import java.util.LinkedHashMap;
import java.util.Map;

public class InMemoryLRUAccessTokenCache
implements IAccessTokenCache {
    private final Map<String, String> cache;

    public InMemoryLRUAccessTokenCache(final int maxEntries) {
        this.cache = new LinkedHashMap<String, String>(maxEntries, 0.75f, true){
            private static final long serialVersionUID = -187234623489L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > maxEntries;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        Map<String, String> map = this.cache;
        synchronized (map) {
            this.cache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        Map<String, String> map = this.cache;
        synchronized (map) {
            return this.cache.get(key);
        }
    }
}

