/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxWebLink;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;

public class BoxSearchSharedLink
extends BoxJSONObject {
    private String type;
    private BoxItem.Info item;
    private URL accessibleViaSharedLink;
    private BoxAPIConnection api;

    public BoxSearchSharedLink(JsonObject jsonObject, BoxAPIConnection api) {
        super(jsonObject);
        this.api = api;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        super.parseJSONMember(member);
        String memberName = member.getName();
        JsonValue value = member.getValue();
        try {
            if (memberName.equals("type")) {
                this.type = value.asString();
                return;
            }
            if (!memberName.equals("item")) {
                if (!memberName.equals("accessible_via_shared_link")) return;
                this.accessibleViaSharedLink = new URL(value.asString());
                return;
            }
            JsonObject jsonObject = value.asObject();
            String type = jsonObject.get("type").asString();
            String id = jsonObject.get("id").asString();
            if (type.equals("folder")) {
                BoxFolder folder;
                BoxFolder boxFolder = folder = new BoxFolder(this.api, id);
                boxFolder.getClass();
                this.item = boxFolder.new BoxFolder.Info(jsonObject);
                return;
            }
            if (type.equals("file")) {
                BoxFile file;
                BoxFile boxFile = file = new BoxFile(this.api, id);
                boxFile.getClass();
                this.item = boxFile.new BoxFile.Info(jsonObject);
                return;
            }
            if (type.equals("web_link")) {
                BoxWebLink link;
                BoxWebLink boxWebLink = link = new BoxWebLink(this.api, id);
                boxWebLink.getClass();
                this.item = boxWebLink.new BoxWebLink.Info(jsonObject);
                return;
            }
            if ($assertionsDisabled) throw new BoxAPIException("Unsupported item type: " + type);
            throw new AssertionError((Object)("Unsupported item type: " + type));
        }
        catch (MalformedURLException e) {
            assert (false) : "A ParseException indicates a bug in the SDK.";
            return;
        }
    }

    public String getType() {
        return this.type;
    }

    public BoxItem.Info getItem() {
        return this.item;
    }

    public URL getAccessibleViaSharedLink() {
        return this.accessibleViaSharedLink;
    }
}

