/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostPort;
import com.microsoft.graph.security.requests.HostPortCollectionPage;
import com.microsoft.graph.security.requests.HostPortCollectionRequestBuilder;
import com.microsoft.graph.security.requests.HostPortCollectionResponse;
import com.microsoft.graph.security.requests.HostPortRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostPortCollectionRequest
extends BaseEntityCollectionRequest<HostPort, HostPortCollectionResponse, HostPortCollectionPage> {
    public HostPortCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostPortCollectionResponse.class, HostPortCollectionPage.class, HostPortCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<HostPort> postAsync(@Nonnull HostPort newHostPort) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostPortRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newHostPort);
    }

    @Nonnull
    public HostPort post(@Nonnull HostPort newHostPort) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostPortRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newHostPort);
    }

    @Nonnull
    public HostPortCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public HostPortCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public HostPortCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public HostPortCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostPortCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public HostPortCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public HostPortCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public HostPortCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public HostPortCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

