/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostPair;
import com.microsoft.graph.security.requests.HostPairCollectionPage;
import com.microsoft.graph.security.requests.HostPairCollectionRequestBuilder;
import com.microsoft.graph.security.requests.HostPairCollectionResponse;
import com.microsoft.graph.security.requests.HostPairRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostPairCollectionRequest
extends BaseEntityCollectionRequest<HostPair, HostPairCollectionResponse, HostPairCollectionPage> {
    public HostPairCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostPairCollectionResponse.class, HostPairCollectionPage.class, HostPairCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<HostPair> postAsync(@Nonnull HostPair newHostPair) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostPairRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newHostPair);
    }

    @Nonnull
    public HostPair post(@Nonnull HostPair newHostPair) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostPairRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newHostPair);
    }

    @Nonnull
    public HostPairCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public HostPairCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public HostPairCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public HostPairCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostPairCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public HostPairCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public HostPairCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public HostPairCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public HostPairCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

