/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.TodoTask;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TodoTaskRequest
extends BaseRequest<TodoTask> {
    public TodoTaskRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTask.class);
    }

    @Nonnull
    public CompletableFuture<TodoTask> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public TodoTask get() throws ClientException {
        return (TodoTask)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<TodoTask> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public TodoTask delete() throws ClientException {
        return (TodoTask)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<TodoTask> patchAsync(@Nonnull TodoTask sourceTodoTask) {
        return this.sendAsync(HttpMethod.PATCH, sourceTodoTask);
    }

    @Nullable
    public TodoTask patch(@Nonnull TodoTask sourceTodoTask) throws ClientException {
        return (TodoTask)this.send(HttpMethod.PATCH, sourceTodoTask);
    }

    @Nonnull
    public CompletableFuture<TodoTask> postAsync(@Nonnull TodoTask newTodoTask) {
        return this.sendAsync(HttpMethod.POST, newTodoTask);
    }

    @Nullable
    public TodoTask post(@Nonnull TodoTask newTodoTask) throws ClientException {
        return (TodoTask)this.send(HttpMethod.POST, newTodoTask);
    }

    @Nonnull
    public CompletableFuture<TodoTask> putAsync(@Nonnull TodoTask newTodoTask) {
        return this.sendAsync(HttpMethod.PUT, newTodoTask);
    }

    @Nullable
    public TodoTask put(@Nonnull TodoTask newTodoTask) throws ClientException {
        return (TodoTask)this.send(HttpMethod.PUT, newTodoTask);
    }

    @Nonnull
    public TodoTaskRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TodoTaskRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

