/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Payload;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PayloadCollectionPage;
import com.microsoft.graph.requests.PayloadCollectionRequestBuilder;
import com.microsoft.graph.requests.PayloadCollectionResponse;
import com.microsoft.graph.requests.PayloadRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PayloadCollectionRequest
extends BaseEntityCollectionRequest<Payload, PayloadCollectionResponse, PayloadCollectionPage> {
    public PayloadCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PayloadCollectionResponse.class, PayloadCollectionPage.class, PayloadCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Payload> postAsync(@Nonnull Payload newPayload) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PayloadRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newPayload);
    }

    @Nonnull
    public Payload post(@Nonnull Payload newPayload) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PayloadRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPayload);
    }

    @Nonnull
    public PayloadCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PayloadCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PayloadCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PayloadCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PayloadCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PayloadCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PayloadCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public PayloadCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public PayloadCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

